#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cassert>
#include <cmath>
#include "corr.h"

using namespace std;

const double eps = 1.01e-3;

bool read_token(char *judge, char *luser) {
   if(fscanf(judgeout, "%100s", judge) == EOF) {
      return false;
   }

   if(fscanf(teamout, "%100s", luser) == EOF) {
      report_error("User EOF while judge had more output");
   }
   return true;
}

int main(int argc, char **argv) {
   init_io(argc, argv);

   char judge[200], luser[200];
   char trash[50];

   while(read_token(judge, luser)) {
      double j, l;
      if(sscanf(judge, "%lf%10s", &j, trash) == 1) {
	 if(sscanf(luser, "%lf%10s", &l, trash) != 1) {
	    report_error("Expected float, got: %s", luser);
	 }
	 if(!(fabs(j - l) <= eps)) {
	    report_error("Too large difference. Judge: %lf, Team: %lf (eps: %lf)", j, l, eps);
	 }
      } else {
	 if(strcasecmp(judge, luser) != 0) {
	    report_error("String tokens mismatch\nJudge: \"%s\"\nTeam: \"%s\"\n", judge, luser);
	 }
      }
   }

   if(fscanf(judgeout, "%100s", judge) != EOF)
      assert(!"Trailing judge output");

   if(fscanf(teamout, "%100s", luser) != EOF)
      report_error("Trailing output");

	printf("Correct output\n");
   exit(EXIT_AC);
}
