
import java.io.*;
import java.util.*;


public class triangles {

  public static double length(double x1, double y1, double x2, double y2){
    return Math.sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
  }
  
  public static boolean appEquals(double a, double b){
    if((a < b + 0.03) && (a > b - 0.03) && !((a < b + 0.01) && (a > b -  0.01))){
      System.err.println("WARNING, COMPARISON TOO CLOSE");
    }
    return (a < b + 0.01) && (a > b -  0.01);
  }

  public static void main(String[] argv)
    throws Exception {
  
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
  
    while(true){
      String l = in.readLine().trim();
      //System.err.println(l);
      StringTokenizer t = new StringTokenizer(l);

      if(t.countTokens()==1){
	System.out.println("End of Output");
	System.exit(0);
      }

      if(t.countTokens()!=6){
	System.err.println("Line without 6 args!!!");
      }

      double x1,y1,x2,y2,x3,y3;

      x1 = Double.parseDouble(t.nextToken());
      y1 = Double.parseDouble(t.nextToken());
      x2 = Double.parseDouble(t.nextToken());
      y2 = Double.parseDouble(t.nextToken());
      x3 = Double.parseDouble(t.nextToken());
      y3 = Double.parseDouble(t.nextToken());

      double a = length(x1,y1,x2,y2);
      double b = length(x2,y2,x3,y3);
      double c = length(x3,y3,x1,y1);

      if(c< a){
	double tmp = a;
	a = c;
	c = tmp;
      }

      if(c < b){
	double tmp=b;
	b=c;
	c = tmp;
      }


      if(appEquals(c,a+b)){
	System.out.println("Not a Triangle");
        continue;
      }


      double c2 = c*c;
      double a2b2 = a*a+b*b;

      //System.err.println(a+" "+b+" "+c+":"+c2+" "+a2b2);

      String lengthName="";
      String angleName="";
    
      if(appEquals(a,b) && appEquals(b,c))
	lengthName = "Equilateral";
      else{
	if(appEquals(a,b) || appEquals(b,c) || appEquals(a,c))
	  lengthName = "Isosceles";
	else
	  lengthName = "Scalene";
      }

      if(appEquals(c2,a2b2))
	angleName = "Right";
      else{
	if(c2 < a2b2)
	  angleName = "Acute";
	else
	  angleName = "Obtuse";
      }

      System.out.println(lengthName+" "+angleName);
    }
  }
}


    
