
import java.io.*;
import java.util.*;



public class rrn {

  public static int romanChars(char c){
    switch(c){
    case 'M':
      return 1000;
    case 'D':
      return 500;
    case 'C':
      return 100;
    case 'L':
      return 50;
    case 'X':
      return 10;
    case 'V':
      return 5;
    case 'I':
      return 1;
    default:
      System.err.println("unknown char "+c);
    }
    return -10000;
  }

  public static int parseRomanNumeral(String r){

    char[] roman = r.toCharArray();

    int total = 0;
    int last = romanChars(roman[0]);
    int cur;

    if(roman.length == 1)
      return last;

    for(int i=1;i<roman.length;i++){
      cur = romanChars(roman[i]);

      if(last < cur)
	cur = cur - last;
      else
	total += last;

      last = cur;
    }

    total += last;

    //System.err.println("mapped "+r+" to "+total);
    return total;
  }

  public static String printRomanNumeral(int x){
    int[] values = {1000,500,100,50,10,5,1};
    char[] letters = {'M','D','C','L','X','V','I'};
    String r = "";

    for(int i=0;i<values.length;i++){
      while(x>=values[i]){
	r+=letters[i];
	x-=values[i];
      }
      if(i<values.length-1 && values[i] == 5*values[i+1]){
	int c = values[i]-values[i+1];

	if (x >= c){
	  r += letters[i+1]+""+letters[i];
	  x -= c;
	}
      }
      if(i<values.length-2 && values[i] == 10*values[i+2]){
	int c = values[i]-values[i+2];

	if (x >= c){
	  r += letters[i+2]+""+letters[i];
	  x -= c;
	}
      }
    }

    return r;
  }

  public static void main(String[] argv)
    throws Exception {
    /*for(int i=1;i<5000;i++)
      if(parseRomanNumeral(printRomanNumeral(i)) != i)
	System.out.println(i+" = "+printRomanNumeral(i) +" parsed as "+
	parseRomanNumeral(printRomanNumeral(i)));*/

    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    Stack s = new Stack();

    String l;

    NEWLINE:
    while((l = in.readLine())!=null){

      if (l.matches("[-*/+]")){
	if(s.size() < 2){
	  System.out.println("stack underflow");
	  continue;
	}

	int arg2 = ((Integer)s.pop()).intValue();
	int arg1 = ((Integer)s.pop()).intValue();
	int x;

	switch(l.charAt(0)){
	case '+':
	  x = arg1+arg2;
	  break;
	case '-':
	  x = arg1-arg2;
	  break;
	case '*':
	  x = arg1*arg2;
	  break;
	case '/':
	  if(arg2 == 0){
	    System.out.println("division by zero exception");
	    s.push(new Integer(arg1));
	    continue NEWLINE;
	  }
	  x = arg1/arg2;
	  break;
	default:
	  System.err.println("shouldn't get here");
	  x = -10000;
	}

	s.push(new Integer(x));
	continue;
      }

      if(l.equals("=")){
	if(s.size() < 1){
	  System.out.println("stack underflow");
	  continue;
	}
	int arg1 = ((Integer)s.peek()).intValue();
	
	if(arg1 < 1 || arg1 > 4999){
	  System.out.println("out of range exception");
	  continue;
	}

	System.out.println(printRomanNumeral(arg1));
	continue;
      }

      s.push(new Integer(parseRomanNumeral(l)));
    }
  }
      
}
