import java.io.*;
import java.util.*;

public class tidal {
  
  public static int[] getTimeRange(BufferedReader in, int maxDays)
    throws Exception {
    int maxTime = maxDays*24*60*60;
    int time = 0;

    StringTokenizer t = new StringTokenizer(in.readLine(), ": ");
    
    time =  60*60*Integer.parseInt(t.nextToken())+
      60*Integer.parseInt(t.nextToken())+
      Integer.parseInt(t.nextToken());
    int interval = 60*60*Integer.parseInt(t.nextToken())+
      60*Integer.parseInt(t.nextToken())+
      Integer.parseInt(t.nextToken());

    int nEntries = (maxDays*24*60*60)/interval+1;

    System.err.println(nEntries+" from "+time+" every "+interval);

    int[] times = new int[nEntries];

    for(int i=0;i<times.length;i++){
      times[i] = time + interval*i;
      System.err.println("tide "+i+":"+times[i]);
    }

    return times;
  }

  public static void recurseDock(int[] pred, int dock, int nextDock, 
				 int[] arrivalDay){
      if(dock!=0)
	  recurseDock(pred, pred[dock], dock, arrivalDay);
      int nDays=1;
      if(nextDock < Integer.MAX_VALUE)
	  nDays = arrivalDay[nextDock]-arrivalDay[dock];
      if(dock>0 || nDays > 1)
	  for(int i=0;i<nDays;i++)
	      System.out.print(dock+" ");
  }
    
    
  public static void main(String[] argv)
    throws Exception {
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
      
    while(true){

      StringTokenizer t;
	
      int maxDays = Integer.parseInt(in.readLine().trim());
      if(maxDays < 1)
	break;
      double speed  = Double.parseDouble(in.readLine().trim()) / (60 * 60);
	
      // time in cumulative seconds
      int[] sunrise = getTimeRange(in,maxDays);
      int[] sunset = getTimeRange(in,maxDays);
      int[] tides = getTimeRange(in,maxDays);
	
      t = new StringTokenizer(in.readLine());

      // for each dock, calculate first access time and last access time of day
      int dockN = Integer.parseInt(t.nextToken())+1;
	
      double[] dockDistance = new double[dockN];
      int[][] dockOpen = new int[dockN][maxDays];
      int[][] dockClosed = new int[dockN][maxDays];

      for(int dock=0;dock<dockN;dock++){
	t = new StringTokenizer(in.readLine());
	dockDistance[dock] = Double.parseDouble(t.nextToken());
	  
	int tideHours = Integer.parseInt(t.nextToken());

	int tideI=0;
	for(int day = 0;day<maxDays;day++){
	  dockOpen[dock][day] = sunrise[day];
	  while(tides[tideI] < sunrise[day]){
	    if(tides[tideI]+tideHours*60*60 > dockOpen[dock][day])
	      dockOpen[dock][day] = tides[tideI]+tideHours*60*60;
	    tideI++;
	  }
	  if(tides[tideI]-tideHours*60*60 < dockOpen[dock][day])
	    dockOpen[dock][day] = tides[tideI]+tideHours*60*60;

	  dockClosed[dock][day] = sunset[day];
	  while(tides[tideI] < sunset[day]){
	    if(tides[tideI]+tideHours*60*60 > dockClosed[dock][day])
	      dockClosed[dock][day] = tides[tideI]-tideHours*60*60;
	    tideI++;
	  }
	  if(tides[tideI]-tideHours*60*60 < dockClosed[dock][day])
	    dockClosed[dock][day] = tides[tideI]-tideHours*60*60;
	}
      }

      for(int day = 0;day<maxDays;day++){
	System.err.println("Day "+day+" sunrise:"+sunrise[day]+
			   " set:"+sunset[day]);
	for(int dock=0;dock<dockN;dock++)
	  System.err.println("dock "+dock+" open:"+dockOpen[dock][day]+" close:"+
			     dockClosed[dock][day]);
      }



      int[] arrivalDay = new int[dockN];
      int[] pred = new int[dockN];

      for(int i=0;i<dockN;i++)
	arrivalDay[i] = Integer.MAX_VALUE;
	
      arrivalDay[0] = -1;
      pred[0] = -1;

      for(int dock=0;dock<dockN;dock++){
	  if(arrivalDay[dock] >= maxDays)
	      continue;
	  for(int day = arrivalDay[dock]+1;day < maxDays;day++){
	      int startTime = dockOpen[dock][day];
	 
	      System.err.println("STARTED AT DOCK "+dock+" on day "+day);
	      
	      for(int dest = dock+1;dest<dockN;dest++){
		  int destTime = dockClosed[dest][day];
		  if(dockOpen[dest][day] > dockClosed[dest][day])
		      destTime = 0;
		  if( (destTime - startTime)*speed + dockDistance[dock] >=
		      dockDistance[dest] && 
		      day <= arrivalDay[dest]){
		      System.err.println("can reach "+dest+
					 "start = "+startTime+" destTime = "+
					 destTime+" dist traveled "+
					 ((destTime-startTime)*speed)+
					 " = pos "+
					 ((destTime - startTime)*speed + dockDistance[dock])+
					 " >= "+dockDistance[dest]);
		      arrivalDay[dest] = day;
		      pred[dest] = dock;
		  }
		  else{
		      if(day > arrivalDay[dest])
			  System.err.println("can get to dock "+dest+" earlier");
		      else
			  System.err.println("destTime "+destTime+" startTime "+startTime+
					     " start "+dockDistance[dock] +" = "+
					     ((destTime - startTime)*speed + dockDistance[dock])+
					     " < goal "+dockDistance[dest]);
		  }
	      }
	  }
      }
      arrivalDay[0] = 0;

      System.err.print("ARRIVAL VECTOR: ");
      for(int i=0;i<arrivalDay.length;i++)
	System.err.print(arrivalDay[i]+" ");
      System.err.println();

      if(arrivalDay[dockN-1] >= maxDays){
	System.out.println("NO ITINERARY POSSIBLE");
	continue;
      }

      recurseDock(pred, dockN-1, Integer.MAX_VALUE, arrivalDay);
      System.out.println();
    }
  }
}

	
	    
		
	
	
	
	
