//#include <ansi_c.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>


// define constants
#define SIDE_TOLERANCE  0.1
#define ANGLE_TOLERANCE  2.0
#define PI 3.14159265

// calculates distance between points
double calcLen(double x1, double y1, double x2, double y2) {
	return (sqrt( (x1-x2)*(x1-x2) + (y1-y2)*(y1-y2)));
}

// use law of cosines to find angles
double lawOfCosines(double opSide, double a, double b){
    return (acos((a*a + b*b - opSide*opSide)/ (2*a*b)))/PI * 180.0;
}
// i.e. floating point compare
int withinTolerance(double val1, double val2, double tolerance) {
	return fabs(tolerance) > fabs(val1-val2);
}

// main routine
//***********************************************************
int main (int argc, char **argv) {
//************************************************************
	double x1,x2,x3,y1,y2,y3; // holds coridnates of points
	double s1,s2,s3;  // side lengths
	double a1,a2,a3;  // angle measurements
	int EqualSides;
	
    while (fscanf(stdin,"%lf%lf%lf%lf%lf%lf",&x1,&y1,&x2,&y2,&x3,&y3)==6){
// calculate lengths
		s1 = calcLen(x1,y1,x2,y2);
		s2 = calcLen(x1,y1,x3,y3);
		s3 = calcLen(x3,y3,x2,y2);
// calculate angles
		a1 = lawOfCosines(s1,s2,s3);
		a2 = lawOfCosines(s2,s1,s3);
		a3 = lawOfCosines(s3,s2,s1);
// determine type
		if (withinTolerance(s1,0,SIDE_TOLERANCE) ||
			withinTolerance(s2,0,SIDE_TOLERANCE) ||
			withinTolerance(s3,0,SIDE_TOLERANCE) ||
			withinTolerance(a1,180,ANGLE_TOLERANCE) ||
			withinTolerance(a2,180,ANGLE_TOLERANCE) ||
			withinTolerance(a3,180,ANGLE_TOLERANCE)
			) { // degenerate cases
			fprintf(stdout,"Not a Triangle\n");
		}
		else {  // valid triangle, find type
			// first do sides
			EqualSides = 0;
			if (withinTolerance(s1,s2,SIDE_TOLERANCE)) { EqualSides++; }
			if (withinTolerance(s1,s3,SIDE_TOLERANCE)) { EqualSides++; }
			if (withinTolerance(s2,s3,SIDE_TOLERANCE)) { EqualSides++; }
			switch (EqualSides) {
				case 0: fprintf(stdout,"Scalene "); break;
				case 1:
				case 2: fprintf(stdout,"Isosceles "); break;
				case 3: fprintf(stdout,"Equilateral ");
			}
			// then do angles
			if  (	withinTolerance(a1,90,ANGLE_TOLERANCE) ||
					withinTolerance(a2,90,ANGLE_TOLERANCE) ||
					withinTolerance(a3,90,ANGLE_TOLERANCE) ) {
				fprintf(stdout,"Right\n");
			}
			else {
				if ( (a1 > 90) || (a2 > 90) || (a3 > 90)) {
					fprintf(stdout,"Obtuse\n");
				}
				else {
					fprintf(stdout,"Acute\n");
				}
			}
		}
	}
	fprintf(stdout,"End of Output\n");
}

