import java.io.*;
import java.util.*;

class Node {
  String city;

  Set roads;

  public String toString(){
    return "NODE: "+city+" with "+roads;
  }
}

class Edge {
  String road;
  String dest;
  
  Hashtable costs;

  public boolean equals (Object o){
    Edge x = (Edge) o;

    return road.equals(x.road) && dest.equals(x.dest);
  }

  public int hashCode(){
    return road.hashCode() + dest.hashCode();
  }

  public String toString(){
    return "road "+road+" to "+dest;
  }
}

class Path {
  String source;
  String road;

  public String toString(){
    return source+" via "+road;
  }
}

public class map {
  public static String TIME = "time";
  public static String DIST = "dist";
  public static String TURNS = "turn";
  
  public static void main(String[] argv)
    throws Exception {
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    
    Hashtable cityGraph = new Hashtable();
    Hashtable roadGraph = new Hashtable();

    int Ncities = Integer.parseInt(in.readLine().trim());

    for(int i=0;i<Ncities;i++){
      Node a = new Node();
      
      a.city = in.readLine().trim();
      a.roads = new HashSet();

      cityGraph.put(a.city, a);
    }
    
    int Nroads = Integer.parseInt(in.readLine().trim());
    
    for(int i=0;i<Nroads;i++){
      StringTokenizer t = new StringTokenizer(in.readLine());

      String roadName = t.nextToken();

      String lastCity = t.nextToken();
      String nextCity;

      Node roadNode = new Node();
      roadNode.city = roadName;
      roadNode.roads = new HashSet();
      roadGraph.put(roadName, roadNode);

      while(t.hasMoreElements()){
	double edgeDist = Double.parseDouble(t.nextToken());
	double edgeTime = Double.parseDouble(t.nextToken());
	nextCity = t.nextToken();
	
	Node lc = (Node) cityGraph.get(lastCity);
	Node nc = (Node) cityGraph.get(nextCity);
	
	Edge e = new Edge();
	e.road = roadName;
	e.dest = nextCity;
	e.costs = new Hashtable();
	e.costs.put(TIME, new Double(edgeTime));
	e.costs.put(DIST, new Double(edgeDist));
	lc.roads.add(e);

	Edge f = new Edge();
	f.road = e.road;
	f.dest = lastCity;
	f.costs = e.costs;
	nc.roads.add(f);
      
	lastCity = nextCity;
      }

    }


    for(Iterator doCities = cityGraph.values().iterator();
	doCities.hasNext();){
      Node city = (Node) doCities.next();

      Object[] cityRoads = city.roads.toArray();

      if(cityRoads.length==1){
	Node roadNode = (Node) roadGraph.get(((Edge)cityRoads[0]).road);
	Edge newCityEdge = new Edge();
	newCityEdge.road = city.city;
	newCityEdge.dest = ((Edge)cityRoads[0]).road;
	newCityEdge.costs = new Hashtable();
	newCityEdge.costs.put(TURNS, new Double(1));
	roadNode.roads.add(newCityEdge);
      }	
      
      for(int i=0;i<cityRoads.length;i++)
	for(int j=i+1;j<cityRoads.length;j++){
	  Node roadNode = (Node) roadGraph.get(((Edge)cityRoads[i]).road);
	  Edge newCityEdge = new Edge();
	  newCityEdge.road = city.city;
	  newCityEdge.dest = ((Edge)cityRoads[j]).road;
	  newCityEdge.costs = new Hashtable();
	  newCityEdge.costs.put(TURNS, new Double(1));
	  roadNode.roads.add(newCityEdge);

	  roadNode = (Node) roadGraph.get(((Edge)cityRoads[j]).road);
	  newCityEdge = new Edge();
	  newCityEdge.road = city.city;
	  newCityEdge.dest = ((Edge)cityRoads[i]).road;
	  newCityEdge.costs = new Hashtable();
	  newCityEdge.costs.put(TURNS, new Double(1));
	  roadNode.roads.add(newCityEdge);
	}
    }

    String l;
    while((l = in.readLine() )!=null){
      StringTokenizer t = new  StringTokenizer(l);

      String alg = t.nextToken();
      String startCity = t.nextToken();
      String destCity = t.nextToken();

      if(alg.equals("turns")){
	Hashtable bestPred = null;
	String bestLastRoute = null;
	int minTurns = Integer.MAX_VALUE;
	Node city = (Node) cityGraph.get(startCity);
	for(Iterator doRoads =  city.roads.iterator();
	    doRoads.hasNext();){
	  Edge road = (Edge) doRoads.next();

	  Hashtable tempPred = new Hashtable();
	  
	  String lastRoute = shortestRoadPath(roadGraph, road.road, 
					      destCity, TURNS, tempPred);
	  int nt = pathCount(startCity, lastRoute, tempPred);
	  if (nt < minTurns){
	    minTurns = nt;
	    bestPred = tempPred;
	    bestLastRoute = lastRoute;
	  }
	}
	System.out.println("from "+startCity);
	String lastRoad = recurseRoadPath(startCity, bestLastRoute, bestPred);
	System.out.println(bestLastRoute+" to "+destCity);
      }
      else {
	String costtype;
	if(alg.equals("distance")){
	  costtype = DIST;
	}
	else {
	  costtype = TIME;
	}
	Hashtable predecessors = shortestPath(cityGraph, startCity, destCity, 
					      costtype);
	
	System.out.println("from "+startCity);
	String lastRoad = recursePath(startCity, destCity, predecessors);
	System.out.println(lastRoad+" to "+destCity);
      }
      

    }
  }

  static Hashtable shortestPath(Hashtable graph, String startCity,
				String destCity, String costtype){
    Hashtable predecessors = new Hashtable();
    Hashtable costTo = new Hashtable();
    Set visited = new HashSet();

    Node curNode = (Node) graph.get(startCity);
    
    double currentWeight = 0;

    visited.add(startCity);

    while(!curNode.city.equals(destCity)){
      for(Iterator doC = curNode.roads.iterator();
	  doC.hasNext();){
	  
	Edge road = (Edge) doC.next();

	if(!visited.contains(road.dest)){
	  double newWeight = currentWeight + 
	    ((Double)road.costs.get(costtype)).doubleValue();
	  double oldWeight = Double.MAX_VALUE;
	  if(costTo.get(road.dest)!=null)
	    oldWeight = ((Double)costTo.get(road.dest)).doubleValue();
	  if( oldWeight > newWeight){
	    costTo.put(road.dest, new Double(newWeight));
	    Path p = new Path();
	    p.source = curNode.city;
	    p.road = road.road;
	    predecessors.put(road.dest, p);
	  }
	}
      }
	  
      double mincost=Double.MAX_VALUE;
      String minCity=null;
      for(Iterator doCosts = costTo.keySet().iterator();
	  doCosts.hasNext();){
	String city = (String) doCosts.next();
	double thisCost = ((Double)costTo.get(city)).doubleValue();
	if(thisCost< mincost){
	  mincost = thisCost;
	  minCity = city;
	}
      }
	
      curNode = (Node) graph.get(minCity);
      costTo.put(minCity, new Double(Double.MAX_VALUE));
      currentWeight = mincost;
      visited.add(curNode.city);
    }

    return predecessors;
  }


  static String shortestRoadPath(Hashtable graph, String startCity,
				    String destCity, String costtype,
				    Hashtable predecessors){
    Hashtable costTo = new Hashtable();
    Set visited = new HashSet();

    Node curNode = (Node) graph.get(startCity);
    
    double currentWeight = 0;

    visited.add(startCity);

    while(true){
      for(Iterator doC = curNode.roads.iterator();
	  doC.hasNext();){
	Edge road = (Edge) doC.next();

	if(road.road.equals(destCity))
	  return curNode.city;

	if(!visited.contains(road.dest)){
	  double newWeight = currentWeight + 
	    ((Double)road.costs.get(costtype)).doubleValue();
	  double oldWeight = Double.MAX_VALUE;
	  if(costTo.get(road.dest)!=null)
	    oldWeight = ((Double)costTo.get(road.dest)).doubleValue();
	  if( oldWeight > newWeight){
	    costTo.put(road.dest, new Double(newWeight));
	    Path p = new Path();
	    p.source = curNode.city;
	    p.road = road.road;
	    predecessors.put(road.dest, p);
	  }
	}
      }
	  
      double mincost;
      String minCity=null;
      mincost=Double.MAX_VALUE;

      for(Iterator doCosts = costTo.keySet().iterator();
	  doCosts.hasNext();){
	String city = (String) doCosts.next();
	double thisCost = ((Double)costTo.get(city)).doubleValue();
	if(thisCost< mincost){
	  mincost = thisCost;
	  minCity = city;
	}
      }
      
      curNode = (Node) graph.get(minCity);
      costTo.put(minCity, new Double(Double.MAX_VALUE));
      currentWeight = mincost;
      visited.add(curNode.city);
    }
  }

  static String recursePath(String startCity, String destCity, 
			    Hashtable predecessors){
    Path p = (Path) predecessors.get(destCity);
    if(!p.source.equals(startCity)){
      String lastRoad = recursePath(startCity, p.source, predecessors);
      if(!lastRoad.equals(p.road))
	System.out.println(lastRoad+" to "+p.source);
    }
    return p.road;
  }

  static int pathCount(String startCity,String lastRoute, 
		       Hashtable predecessors){
    Path p = (Path) predecessors.get(lastRoute);
    if(p!= null)
      return pathCount(startCity, p.source, predecessors) + 1;
    else
      return 0;
  }


  static String recurseRoadPath(String startCity,String lastRoute, 
			     Hashtable predecessors){
    Path p = (Path) predecessors.get(lastRoute);
    if(p!=null){
      recurseRoadPath(startCity, p.source, predecessors);
      System.out.println(p.source+" to "+p.road);
    }
    return null;
  }
}
  
      
      

