/* NWERC 2006
 * Sample solution to Sudoku
 * By Mikael Goldmann
 *
 * Some speed-ups: 
 *  Stops if a consistent transformation is found.
 *  Fixes three columns of the permutation at a time 
 *    (may allow pruning of many perms at once).
 */

import java.util.*;

class sudoku_mg {
    static Scanner in = new Scanner(System.in);
    
    static final int[][] perm3 ={ 
	{ 0,1,2 },
	{ 0,2,1 },
	{ 1,0,2 },
	{ 1,2,0 },
	{ 2,0,1 },
	{ 2,1,0 }
    };
    
    /* For column block colblock (0==cols 0,1,2, 1==cols 3,4,5, 2==cols 6,7,8)
     * check if there is a permution of the three columns in the block that allows
     * a consistent extension of the substitution subst.
     */

    boolean match(int colblock,
		  int[][] prev,
		  int[][] curr,
		  boolean transp,
		  int rowq,
		  int[] rowp,
		  int colq,
		  int[] subst
		  )
    {

  
	if (colblock==3) return true; // have successfully fixed all columns
  
	int[] subst1 = new int[10];
	boolean ok;  
	for (int cp=0; cp<6; ++cp) {    
	    ok=true;    
	    for (int i=0; i< subst.length; ++i) subst1[i]=subst[i];
	    for (int rowblock=0; ok && rowblock<3; ++rowblock)
		for (int r1=0; r1<3; ++r1) {
		    int crowinx = perm3[rowq][rowblock]*3 + perm3[rowp[rowblock]][r1];
		    int prowinx = rowblock*3 + r1;		
		    for (int c1=0; c1<3; ++c1) {	  
			int ccolinx = perm3[colq][colblock]*3 + perm3[cp][c1];
			int pcolinx = colblock*3 + c1;
			int pnum = prev[prowinx][pcolinx], 
			    cnum=curr[crowinx][ccolinx];	  
			if (transp) cnum=curr[ccolinx][crowinx];
	  
			if (cnum!=0)
			    if (subst1[cnum]==0) subst1[cnum]=pnum;
			    else if(subst1[cnum] != pnum) ok = false;
		    }
	
		}
	    if (ok && match(colblock+1, prev, curr, transp, rowq, rowp, colq, subst1)) return true;
    
	}
  
	return false;  
    }


    void solve() throws Exception
    {
	int[][] prev = new int[9][9], curr = new int[9][9];
	String line;  
	for (int i=0; i<9; ++i) {
	    line=in.next();
	    for (int j=0;j<9;++j) prev[i][j] = line.charAt(j)-'0';
	}
	for (int i=0; i<9; ++i) {
	    line=in.next();
	    for (int j=0;j<9;++j) curr[i][j] = line.charAt(j)-'0';
	}
	int rowq, colq;
	int[] rowp = new int[3];
	
	int[] subst = new int[10];
	Arrays.fill(subst,0);  
	for (rowq=0; rowq<6; ++rowq) 
	    for (rowp[0]=0; rowp[0]<6; ++rowp[0])
		for (rowp[1]=0; rowp[1]<6; ++rowp[1])
		    for (rowp[2]=0; rowp[2]<6; ++rowp[2])
			for (colq=0; colq<6; ++colq)
			    for (int tt=0; tt<2; ++tt)
				if (match(0,prev, curr, tt==0, rowq, rowp, colq/*, colp*/, subst)){
				    System.out.println("Yes");
		  
				    return;
				}
  
	System.out.println("No");
    }


    public  static void main(String[] args) throws Exception
    {
	int n;  
	for (n=in.nextInt(); n>0; --n) new sudoku_mg().solve();
    }
}
