/* NWERC 2006
 * Sample solution to Leonardo's notebook
 * By Mikael Goldmann
 * A permutation P is a square 
 *       if and only if 
 * for all k, P has en even number of cycles of length 2k 
 */

import java.util.Scanner;
import java.util.Arrays;

class notebook_mg 
{
    static Scanner in = new Scanner(System.in);    
    static int[] nlen = new int[27], perm=new int[26];
    static boolean solve() throws Exception
    {
	Arrays.fill(nlen,0);  
	String txt = in.next();	
	for (int i=0; i<26; ++i) perm[i] = txt.charAt(i)-'A';
	// count number of cycles of each length
	for (int i=0; i<26;++i) {
	    int len=0 ,x=i;
	    while (perm[x] != -1) {
		int px = perm[x];
		perm[x]=-1;
		++len;
		x=px;      
	    }
	    ++nlen[len]; 
	}
	for (int i=2; i<=26; i+=2)
	    if ((nlen[i]&1)==1) return false; 
	return true;  
    }
    
    
    public static void  main(String[] args) throws Exception
    {
	int n = in.nextInt();
	while(n-->0) 
	    System.out.println(solve() ? "Yes" : "No");  
    }
}
