/* Warning!
 * This solution is incorrect!  It fails for e.g. the following case:
 *
 * 4 8
 * 0 0
 * 4 2
 * 7 2
 * 12 7
 *
 * The correct answer is 11.5.
 *
 * While this solution was one of the official judge solutions for
 * this problem, the official test data used does not contain any
 * cases such as the one above (so the test data used in the contest
 * was incomplete, but not incorrect).
 *
 *
 * / Per Austrin, Head Judge, NWERC 2006
 *   2006-11-27
 *
 */

#include <stdio.h>
#include <math.h>

#define MAXN (500)
int L,x[MAXN],y[MAXN],dp[MAXN],car[MAXN];
double best;

void area(int lix,int rix,double dx,int low)
{
  double sum=car[lix]-car[rix];
  double ex=x[rix]-x[lix]-L;
  double ly=y[lix]+(double)(y[lix+1]-y[lix])*dx/(x[lix+1]-x[lix]);
  double ry=y[rix]+(double)(y[rix-1]-y[rix])*(ex-dx)/(x[rix]-x[rix-1]);
  double lp=ly;
  if (ry<lp) lp=ry;
  if (low>-1 && y[low]<lp) lp=y[low];
  sum-=(ex-dx)*(ry+y[rix])+dx*(ly+y[lix])+2*L*lp;  
  if (sum<best) best=sum;
}

int main()
{
  int T,n,i,j,lix,rix,low;
  scanf("%d",&T);
  while(T--)
  {
    scanf("%d %d",&n,&L);
    for (i=0;i<n;i++)
      scanf("%d %d",&x[i],&y[i]);      
    dp[n-1]=-1;car[n-1]=0;
    for (i=n-2;i>=0;i--)
    {
      int ix=i+1; while (ix>-1 && y[ix]>y[i]) ix=dp[ix]; dp[i]=ix;  
      car[i]=car[i+1]+(y[i]+y[i+1])*(x[i+1]-x[i]);
    }  
  
    low=lix=rix=0; while (x[rix]-x[0]<L) rix++;
    best=1e10;
    while(rix<n)
    {
      // ry-y[lix]=(dly-dry)*x
      int ex=x[rix]-x[lix]-L;
      double rly=y[rix]+(double)(y[rix-1]-y[rix])*ex/(x[rix]-x[rix-1])-y[lix];
      double dlry=(double)(y[lix+1]-y[lix])/(x[lix+1]-x[lix])-(double)(y[rix]-y[rix-1])/(x[rix]-x[rix-1]);
      double dx=0;
      if (abs(dlry)>1e-10) dx=rly/dlry;
        
      if (low<=lix)
      {
        int run=lix+1;
        low=-1;
        while (run>-1 && run<rix)
        {
          low=run;  
          run=dp[run];
        }
      }
        
      if (x[lix]+L>=x[rix-1]) area(lix,rix,0,low); //Left
      if (dx>=0 && dx<=ex && x[lix]+dx+L>=x[rix-1] && x[lix]+dx<=x[lix+1]) 
        area(lix,rix,dx,low); //Middle
     
      if (x[rix]-x[lix+1]>=L) lix++; else
      {
        area(lix,rix,ex,low); // Right 
        rix++;
        if (y[rix-1]<y[low]) low=rix-1;
      }
    }
    printf("%1.6llf\n",best/2);
  }
  return 0;
}
