#include <iostream>
#include <sstream>
#include <string>
#include <map>
#include <list>
#include <set>

using namespace std;

map<string,int> LowestCost;
map<string,int> BuySellPrice;
set<string> ItemList;

int Start;
int Target;

struct Transform
{
	string out;
	map<string,int> needs;

	bool updateCost()
	{
		int total=0;
		for(map<string,int>::iterator I=needs.begin(); I!=needs.end(); I++)
		{
			int qty=I->second;
			string n=I->first;

			//If we can't make it yet
			if (LowestCost.count(n)==0) return false;
			total += qty * LowestCost[n];
		}

		if ((LowestCost.count(out)==0) || (total < LowestCost[out]))
		{
			LowestCost[out]=total;
			return true;
		}
		return false;

	}

};

list<Transform> forms;



int main()
{
	while(true)
	{
		LowestCost.clear();
		BuySellPrice.clear();
		forms.clear();
		ItemList.clear();

		cin >> Start >> Target;

		if ((Start==0) || (Target==0)) return 0;	
		int N;
		cin >> N;

		for(int i=0; i<N; i++)
		{
			int price;
			string name;
			cin >> price >> name;
			LowestCost[name]=price;
			BuySellPrice[name]=price;
			ItemList.insert(name);
		}


		cin >> N;
		for(int i=0; i<N; i++)
		{
			Transform T;
			cin >> T.out;
			string line;
			getline(cin,line);
			istringstream ln(line);
			string colon; ln >> colon;
			while(ln)
			{
				int qty; ln >> qty;
				if (ln)
				{
					string n; ln >> n;
					T.needs[n]=qty;
				}
			}
			forms.push_back(T);
			
		}

		// As long as some price keeps getting lower, run the loop agains
		// At most we might have to run M, totaling M^2 ops.
		bool changed=true;
		while(changed)
		{
			changed=false;
			for(list<Transform>::iterator I=forms.begin(); I!=forms.end(); I++)
			{
				if (I->updateCost()) changed=true;
			}
		}

		int money=Start;
		int round=0;
		while(money < Target)
		{
			round++;
			int next_money=money;
			string next_item;
			int next_cnt;
			for(set<string>::iterator I=ItemList.begin(); I!=ItemList.end(); I++)
			{
				
				string n=*I;
				if (BuySellPrice.count(n))
				{
					int cnt = money / LowestCost[n]; //How many I can get
					int money_new = money - cnt * LowestCost[n] + cnt * BuySellPrice[n];
					if (money_new > next_money)
					{
						next_money=money_new;
						next_item=n;
						next_cnt=cnt;
					}
				}
			}
			money=next_money;
			cout << "Round " << round << ": " <<next_item << " " << next_cnt << endl;

		}
		cout << endl;



	}



}


