#include <iostream>
#include <map>
#include <vector>

using namespace std;

struct bucket
{
	double water;
	int x;
	int y;
	int w;
	int h;

	double getArea(){return w*h;}

	bool hasOverflow(){return (water > getArea());}
	double getOverflow()
	{
		if (water > getArea())
		{
			double over=water - getArea();
			water=getArea();
			return over;
		}
		return 0.0;
	}


};

vector<bucket> Buckets;

double Time;
double FlowRate;
int BC;

void addDrop(int x, int y, double water)
{
	int bucket_height=-1;
	int bucket_idx=-1;

	for(int i=0; i<BC; i++)
	{
		if ((Buckets[i].x <= x) && (x < Buckets[i].x + Buckets[i].w))
		if (Buckets[i].y < y)
		if (Buckets[i].y > bucket_height)
		{
			bucket_height=Buckets[i].y;
			bucket_idx=i;
		}
	}
	if (bucket_idx>=0)
	{
		Buckets[bucket_idx].water += water;
	}
}

int main()
{
	int Case=0;
	while(true)
	{
		Case++;
		cin >> Time >> FlowRate >> BC;
		if(Time==0) return 0;

		Buckets.clear();
		for(int b=0; b<BC; b++)
		{
			bucket k;
			cin >> k.x >> k.y >> k.w >> k.h;
			Buckets.push_back(k);
		}

		for(int i=0; i<100; i++)
		{	
			double W=Time*FlowRate;
			addDrop(i,100,W);

		}

		bool change=true;
		while(change)
		{
			change=false;
			for(int i=0; i<BC; i++)
			{
				if (Buckets[i].hasOverflow())
				{
					change=true;
					double flow=Buckets[i].getOverflow();
					addDrop(Buckets[i].x-1,Buckets[i].y,flow/2.0);
					addDrop(Buckets[i].x + Buckets[i].w, Buckets[i].y,flow/2.0);

				}

			}
		
		}

		printf("System %d\n",Case);
		for(int i=0; i<BC; i++)
		{
			printf("Bucket %d: %0.2lf\n",i+1,Buckets[i].water);
		}
		printf("\n");


	}


}

