#include <iostream>
#include <map>

using namespace std;

map<int,map<int,char> > Grid;

//Do recursive search for 'z' about
// x,y
int rec(int x,int y, char z)
{

	//We are out of the group
	if (Grid[x][y]!=z) return 0;

	// We have this one at least
	int count=1;

	// Destructive search - prevents using the
	// same cell more than once
	Grid[x][y]=0;

	// Add the directions
	// Since you can't fall off the edge of a map
	// we don't care about going negative or whatever.
	// If we go into unallocated space, the map will
	// return 0, which is not equal to 'z'.
	count += rec(x+1,y,z);
	count += rec(x-1,y,z);
	count += rec(x,y+1,z);
	count += rec(x,y-1,z);
	return count;
}

int main()
{
	while(true)
	{
		int N;
		int MX;
		int MY;
		cin >> N >> MX >> MY;

		if (N==0) return 0;

		Grid.clear(); 

		for(int i=0; i<MX; i++)
		for(int j=0; j<MY; j++)
		{
			char z; cin >> z;
			Grid[i][j]=z;
		}

		for(int i=0; i<MX; i++)
		for(int j=0; j<MY; j++)
		{
			char z=Grid[i][j];
			if ((z >= 'A') && (z <= 'Z'))
			{
				if (rec(i,j,z)==N) cout << z;
			}
		}
		cout << endl;
	

	}

}


