#include <iostream>
#include <map>
#include <set>

using namespace std;

map<int,map<int,set<int> > > Squares;
map<int,set<int> > Col;
map<int,set<int> > Row;

int main()
{
	while(true)
	{
		Squares.clear(); Col.clear(); Row.clear();

		bool Valid=true;

		for(int i=0; i<9; i++)
		for(int j=0; j<9; j++)
		{
			int n; cin >> n;
			if (!cin) return 0;
			if ((n < 1) || (n>9))
			{
				Valid=false;
				cerr << "issue: out of range - " << n << " at " << i << "," << j << endl;
			}
			Col[i].insert(n);
			Row[j].insert(n);
			Squares[i/3][j/3].insert(n);
		}
		for(int i=0; i<9; i++)
		{
			if (Col[i].size() !=9)
			{
				Valid=false;
				cerr << "issue: row set fail - " << i << endl;
			}
			if (Row[i].size() !=9)
			{
				Valid=false;
				cerr << "issue: col set fail - " << i << endl;
			}
		}
		for(int i=0; i<3; i++)
		for(int j=0; j<3; j++)
		{
			if (Squares[i][j].size() != 9)
			{
				Valid=false;
				cerr << "issue: box fail - " << i << "," << j << endl;
			}
		}

		if (Valid) cout << "VALID" << endl;
		else cout << "INVALID" << endl;

	}


}

