#include <iostream>
#include <map>
#include <set>

using namespace std;

const int MaxRoom=20;

int NextSearch;

struct Room
{
    bool Closed;
    set<int> Next;
    int sc; //Search counter

    Room()
    {
        Closed=false;
        sc=-1;


    }
};

map<int,Room> M;

bool tryInvade(int room)
{
    if (room==0) return true;

    if (M[room].Closed) return false;
    if (M[room].sc==NextSearch) return false;

    M[room].sc=NextSearch;

    for(set<int>::iterator I=M[room].Next.begin(); I!=M[room].Next.end(); I++)
    {
        if (tryInvade(*I)) return true;
    }
    return false;

}

int MinGate;

void recGate(int room, int gates)
{
    //Already found a better solution
    if (gates >= MinGate) return;

    if (room > MaxRoom)
    {
        NextSearch++;
        if (!tryInvade(1))
        {
            //cout<< "Sol: " << gates << endl;
            MinGate=gates <? MinGate;
        }

        return;
    }

    if (M[room].Next.empty())
    {
        recGate(room+1,gates);
        return;
    }
    recGate(room+1,gates);
    M[room].Closed=true;
    //cout << "gate " << room << " on" << endl;
    recGate(room+1,gates+1);
    //cout << "gate " << room << " off" << endl;
    M[room].Closed=false;
}

int main()
{
    NextSearch=0;
    while(true)
    {
        int N;
        cin >> N;
        if (N==0) return 0;

        M.clear();
        for(int i=0; i<N; i++)
        {
            int a,b;

            cin >> a >> b;
            M[a].Next.insert(b);
            M[b].Next.insert(a);
        }

        MinGate=1000;
        recGate(2,0);
        cout << MinGate << endl;

    }
}

