#include <iostream>
#include <map>
#include <set>
#include <cassert>

using namespace std;

typedef pair<int,int> PI;

struct Square
{
    int  X;
    int  Y;
    int  W;
    int  H;

    bool operator<(const Square &O) const
    {
        if (X < O.X) return true; if (X > O.X) return false;
        if (Y < O.Y) return true; if (Y > O.Y) return false;
        if (W < O.W) return true; if (W > O.W) return false;
        if (H < O.H) return true; if (H > O.H) return false;
        return false;
    }

    long long getArea() const
    {
        long long W2=W;
        long long H2=H;
        return W2*H2;
    }

    void print()
    {
        cout << "Square{" << X << "," << Y << "," << W << "," << H << "}" << endl;

    }

};



void printSetInt(string n, set<int> Z)
{

        cout << n << ":";
        for(set<int>::iterator I=Z.begin(); I!=Z.end(); I++)
        {
                 cout << " " << *I;
        }
        cout << endl;
}

set<int> XInt;
set<int> YInt;
set<Square> SmallSquares;

//returns set, exclusive on min and inclusive max
set<int> getSubList(set<int> &List, int min, int max)
{
    set<int> ret;

    for(set<int>::iterator I=List.upper_bound(min); (I!=List.end()) && (*I <= max); I++)
    {
        ret.insert(*I);
    }

    return ret;

}

void recAdd(Square A)
{


    int X1=A.X;
    int X2=A.X + A.W;
    int Y1=A.Y;
    int Y2=A.Y + A.H;

    //cout << "Checking: "; A.print();


    //X Direction
    set<int> xsub=getSubList(XInt,X1,X2);
    //printSetInt("xsub",xsub);

    assert(xsub.size()>=1);

    if (xsub.size() > 1)
    {
        int XA=X1;
        for(set<int>::iterator I=xsub.begin(); I!=xsub.end(); I++)
        {
            int XB=*I;
            Square S=A;
            S.X=XA;
            S.W=XB-XA;
            recAdd(S);
            XA=XB;

        }
        return;
    }

    //Y Direction
    set<int> ysub=getSubList(YInt,Y1,Y2);
    //printSetInt("ysub",ysub);

    assert(ysub.size()>=1);

    if (ysub.size() > 1)
    {
        int YA=Y1;
        for(set<int>::iterator I=ysub.begin(); I!=ysub.end(); I++)
        {
            int YB=*I;
            Square S=A;
            S.Y=YA;
            S.H=YB-YA;
            recAdd(S);
            YA=YB;

        }
        return;
    }

    //cout << "SmallAdding: "; A.print();

    SmallSquares.insert(A);

}



int main()
{

    while(true)
    {



        set<Square> Input;
        XInt.clear(); YInt.clear(); SmallSquares.clear();

        int N;
        cin >> N;
        if (N==0) return 0;
        for(int n=0; n<N; n++)
        {
            Square S;
            cin >> S.X >> S.Y >> S.W >> S.H;

            Input.insert(S);
            //S.print();

            XInt.insert(S.X);
            XInt.insert(S.X+S.W);
            YInt.insert(S.Y);
            YInt.insert(S.Y+S.H);

        }

        //printSetInt("XInt",XInt);
        //printSetInt("YInt",XInt);

        for(set<Square>::iterator I=Input.begin(); I!=Input.end(); I++)
        {
            recAdd(*I);
        }

        long long Area=0;
        for(set<Square>::iterator I=SmallSquares.begin(); I!=SmallSquares.end(); I++)
        {
            Area+=I->getArea();
        }
        cout << Area << endl;


    }


}


